﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class TaskManager

    ' 当前运行的进程的列表
    Dim processList As New System.Collections.Generic.List(Of ProcessInfo)


    Private Sub btnModules_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnModules.Click
        ' 获取在组合框中当前选择的项。然后通过 frmModules 上
        ' 的 richTextBox 将该进程的所有模块显示给用户。
        Dim processID As Integer = (CType(cboCurrentProcesses.SelectedItem, ProcessInfo)).ID
        Dim modulesForm As New ModulesDisplay
        modulesForm.ProcessID = processID
        modulesForm.Show()
    End Sub

    Private Sub TaskManager_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            ' 循环访问所有运行的进程，将这些进程添加到 ComboBox，
            ' 以便用户可以选择一个进程并查看
            ' 该进程的信息。
            For Each oneProcess As Process In Process.GetProcesses()
                ' Devenv 是 Visual Studio 开发环境。您可以看到，已打开的开发环境
                ' 的每个实例都有一个对应的项。IEXPLORE 是
                ' Internet Explorer。
                If oneProcess.ProcessName = "IEXPLORE" Or oneProcess.ProcessName = "devenv" Then
                    processList.Add(New ProcessInfo(oneProcess.Id, oneProcess.ProcessName))
                End If
            Next
            cboCurrentProcesses.DataSource = processList
            With cboCurrentProcesses
                .DataSource = processList
                .SelectedIndex = 0
            End With

            If btnModules.Enabled = False Then
                btnModules.Enabled = True
            End If
        Catch exc As Exception
            MsgBox("Unable to load process names: " & vbCrLf & "Choose another process.", MsgBoxStyle.OKOnly, Me.Text)
            btnModules.Enabled = False
        End Try
    End Sub

    Private Sub cboCurrentProcesses_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cboCurrentProcesses.SelectedIndexChanged
        Dim processID As Integer

        Try

            ' 根据用户在组合框中选择
            ' 的项检索进程的信息。
            'Dim ProcessListIndex As Integer = cboCurrentProcesses.SelectedIndex
            processID = (CType(cboCurrentProcesses.SelectedItem, ProcessInfo)).ID
            Dim ProcessInfo As Process = _
                Process.GetProcessById(processID)

            '显示有关当前选择的进程的信息。
            txtPriority.Text = ProcessInfo.BasePriority.ToString()
            txtNumberOfThreads.Text = ProcessInfo.Threads.Count.ToString()
            txtMaxWorkingSet.Text = ProcessInfo.MaxWorkingSet.ToString()
            txtMinWorkingSet.Text = ProcessInfo.MinWorkingSet.ToString()
            txtStartTime.Text = ProcessInfo.StartTime.ToLongTimeString()
            txtTotalProcessorTime.Text = ProcessInfo.TotalProcessorTime.ToString()
        Catch exc As Exception
            MsgBox("Unable to retrieve information for ProcessID : " & processID & ".", MsgBoxStyle.OKOnly)
        End Try

    End Sub

    Private Class ProcessInfo
        Public ID As Integer
        Public Name As String
        Public Sub New(ByVal newId As Integer, ByVal newName As String)
            ID = newId
            Name = newName
        End Sub
        Public Overrides Function ToString() As String
            Return Name
        End Function
    End Class

End Class